/*
** CloneCD Image Control File (CCD) treating module
**
** Writen by Sakae Tatibana <tatibana@extra.hu>
**
** 2000, 7/5  coding start
**
*/

#include "binary.h"
#include "filename.h"

#define CCD_C
#include "ccd.h"

typedef struct {
	char path[FILENAME_MAX];
	size_t filesize;

	INI ini;

	int toc_entries;
	int sessions;
	int scramble;
	int version;
	int pregap_mode[100];

} CCD_IMAGE;

int open_ccd_file(char *path, DAO_INFO *out);

int open_ccd_file(char *path, DAO_INFO *out)
{
	int i,n;
	char *s;
	int r;

	CCD_IMAGE w;

    dao_track *t;
    int track;
    int session;
    int control;
	int drop_block;
	LBN current_session_last;
	LBN previous_session_last;

	char section[64];

	memset(&w, 0, sizeof(CCD_IMAGE));

    out->path = path;

	strcpy(w.path, path);
	cut_sfx(w.path);
    strcat(w.path, ".img");

	w.filesize = get_filesize(w.path);

	if(!w.filesize){
		return 0;
	}

	if(! open_ini_file(path, &(w.ini))){
		return 0;
	}

	s = read_ini_element_value(&(w.ini), "CloneCD", "Version");
	if(s[0] == '\0'){
		r = 0;
		goto OPEN_CCD_FILE_END;
	}
	w.version = atoi(s);
	if(w.version != 2){
		r = 0;
		goto OPEN_CCD_FILE_END;
	}

	s = read_ini_element_value(&(w.ini), "Disc", "TocEntries");
	if(s[0] == '\0'){
		r = 0;
		goto OPEN_CCD_FILE_END;
	}
	w.toc_entries = atoi(s);

	s = read_ini_element_value(&(w.ini), "Disc", "Sessions");
	if(s[0] == '\0'){
		r = 0;
		goto OPEN_CCD_FILE_END;
	}
	w.sessions = atoi(s);

	s = read_ini_element_value(&(w.ini), "Disc", "DataTracksScrambled");
	if(s[0] == '\0'){
		r = 0;
		goto OPEN_CCD_FILE_END;
	}
	w.scramble = atoi(s);
	if(w.scramble){
		r = 0;
		goto OPEN_CCD_FILE_END;
	}

	for(i=0;i<w.sessions;i++){
		sprintf(section, "Session %d", i+1);
		s = read_ini_element_value(&(w.ini), section, "PreGapMode");
		if(s[0] == '\0'){
			r = 0;
			goto OPEN_CCD_FILE_END;
		}
		w.pregap_mode[i] = atoi(s);
	}

    session = 0;
	current_session_last = 0;
	drop_block = 0;
	for(i=0;i<w.toc_entries;i++){

		sprintf(section, "Entry %d", i);

        s = read_ini_element_value(&(w.ini), section, "Point");
		sscanf(s, "%x", &track);
		
		if(track == 0xA2){
			previous_session_last = current_session_last;
			s = read_ini_element_value(&(w.ini), section, "PLBA");
			current_session_last = atoi(s);
		}
		if(track > 0x9f){
			continue;
		}

		track -= 1;
		out->num_of_track += 1;

		t = out->track + track;
		t->index = track;
		strcpy(t->path, w.path);

		t->block_size = 2352;

        s = read_ini_element_value(&(w.ini), section, "PLBA");
		t->start = atoi(s);

		s = read_ini_element_value(&(w.ini), section, "Session");
		n = atoi(s) - 1;
		if(n != session){
			drop_block += t->start - previous_session_last;
			session = n;
		}else if(t->index){
			(t-1)->num_of_block = t->start - (t-1)->start;
		}

		t->offset = (t->start - drop_block) * 2352;

        s = read_ini_element_value(&(w.ini), section, "Control");
		sscanf(s, "%x", &control);

		if(control == 4){
			if(w.pregap_mode[session] == 2){
				t->type = DAO_TRACK_TYPE_MODE2;
			}else{
				t->type = DAO_TRACK_TYPE_MODE1;
			}
		}else{
			t->type = DAO_TRACK_TYPE_AUDIO;
		}

		t->num_of_block = current_session_last - t->start;
	}

	r = 1;

OPEN_CCD_FILE_END:
	close_ini_file(&(w.ini));
	return r;
}


